/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_rm extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Temp Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] ETC_UTC = new String[] {
               "Temp universal coordin\u00e0",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Atlantic = new String[] {
               "Temp da standard atlantic",
               "AST",
               "Temp da stad atlantic",
               "ADT",
               "Temp atlantic",
               "AT",
            };
        final String[] Europe_Central = new String[] {
               "Temp da standard da l\u2019Europa Centrala",
               "CET",
               "Temp da stad da l\u2019Europa Centrala",
               "CEST",
               "Temp da l\u2019Europa Centrala",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Temp da standard da l\u2019Europa Orientala",
               "EET",
               "Temp da stad da l\u2019Europa Orientala",
               "EEST",
               "Temp da l\u2019Europa Orientala",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Temp da standard da l\u2019Europa dal Vest",
               "WET",
               "Temp da stad da l\u2019Europa dal Vest",
               "WEST",
               "Temp da l\u2019Europa dal Vest",
               "WET",
            };
        final String[] America_Central = new String[] {
               "Temp da standard central",
               "CST",
               "Temp da stad central",
               "CDT",
               "Temp central",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Temp da standard oriental",
               "EST",
               "Temp da stad oriental",
               "EST",
               "Temp oriental",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Temp da standard pacific",
               "PST",
               "Temp da stad pacific",
               "PDT",
               "Temp pacific",
               "PT",
            };
        final String[] America_Mountain = new String[] {
               "Temp da standard da muntogna",
               "MST",
               "Temp da stad da muntogna",
               "MST",
               "Temp da muntogna",
               "MST",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Halifax", Atlantic },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Europe/Bucharest", Europe_Eastern },
            { "UTC", ETC_UTC },
            { "ART", Europe_Eastern },
            { "CST", America_Central },
            { "ECT", Europe_Central },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Gaza", Europe_Eastern },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Hebron", Europe_Eastern },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Tunis", Europe_Central },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "Africa/Bamako", GMT },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "America/Aruba", Atlantic },
            { "America/Boise", America_Mountain },
            { "America/Thule", Atlantic },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Temp Greenwich",
                    "GMT",
                    "temp da stad britannic",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Inuvik", America_Mountain },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Regina", America_Central },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Temp Greenwich",
                    "GMT",
                    "temp da stad britannic",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Monrovia", GMT },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "America/Antigua", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "America/Anguilla", Atlantic },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Troll", GMT },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Nouakchott", GMT },
            { "America/Chihuahua", America_Central },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Montserrat", Atlantic },
            { "America/St_Vincent", Atlantic },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "timezone.excity.Asia/Brunei", "Bandar Seri Begawan" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "Citad da Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "citad nunenconuschenta" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bischkek" },
            { "timezone.excity.Asia/Karachi", "Karatschi" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Indian/Cocos", "West Island" },
            { "timezone.excity.Pacific/Fiji", "Fidschi" },
            { "timezone.excity.Pacific/Guam", "Hag\u00e5t\u00f1a" },
            { "timezone.excity.Pacific/Niue", "Alofi" },
            { "timezone.excity.Pacific/Truk", "Weno" },
            { "timezone.excity.America/Aruba", "Oranjestad" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Jujuy", "San Salvador de Jujuy" },
            { "timezone.excity.Asia/Ashgabat", "A\u015fgabat" },
            { "timezone.excity.Asia/Dushanbe", "Duschanbe" },
            { "timezone.excity.Asia/Makassar", "Macassar" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Tashkent", "Taschkent" },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "timezone.excity.Europe/Jersey", "Saint Helier" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Moscow", "Moscau" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "timezone.excity.Europe/Zurich", "Turitg" },
            { "timezone.excity.Indian/Comoro", "Comoras" },
            { "timezone.excity.Pacific/Nauru", "Yaren" },
            { "timezone.excity.Pacific/Palau", "Melekok" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algier" },
            { "timezone.excity.America/Belize", "Belmopan" },
            { "timezone.excity.America/Cayman", "Inslas Cayman" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Kamchatka", "Kamtschatka" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Pacific/Easter", "Insla da Pasca" },
            { "timezone.excity.Pacific/Kosrae", "Tofol" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Pacific/Ponape", "Palikir" },
            { "timezone.excity.Pacific/Tarawa", "South Tarawa" },
            { "timezone.excity.Pacific/Wallis", "Mat\u0101\u02bbutu" },
            { "timezone.excity.Africa/Djibouti", "Dschibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Godthab", "Godth\u00e5b" },
            { "timezone.excity.America/Jamaica", "Giamaica" },
            { "timezone.excity.America/Noronha", "Fernando de Noronha" },
            { "timezone.excity.America/Tortola", "Road Town" },
            { "timezone.excity.Asia/Choibalsan", "Tschoibalsan" },
            { "timezone.excity.Atlantic/Azores", "Azoras" },
            { "timezone.excity.Atlantic/Canary", "Inslas Canarias" },
            { "timezone.excity.Atlantic/Faeroe", "Inslas Feroe" },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Europe/Guernsey", "Saint Peter Port" },
            { "timezone.excity.Europe/Uzhgorod", "Uschhorod" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Pacific/Gambier", "Rikitea" },
            { "timezone.excity.Pacific/Norfolk", "Kingston" },
            { "timezone.excity.Africa/Mogadishu", "Mogadischu" },
            { "timezone.excity.America/Anguilla", "The Valley" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Miquelon", "Saint Pierre" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Santa Lucia" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Atlantic/Stanley", "Port Stanley" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Indian/Christmas", "Flying Fish Cove" },
            { "timezone.excity.America/Anchorage", "Alasca" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Europe/Zaporozhye", "Saporischja" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Tongatapu", "Nuku\u02bbalofa" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/Grand_Turk", "Cockburn Town" },
            { "timezone.excity.America/Guadeloupe", "Basse-Terre" },
            { "timezone.excity.America/Montserrat", "Brades" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Antarctica/McMurdo", "Mac Murdo" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/St_Helena", "Sontg\u2019elena" },
            { "timezone.excity.Europe/Isle_of_Man", "Douglas" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Citad da Mexico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cap Verd" },
            { "timezone.excity.Pacific/Guadalcanal", "Honiara" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daressalam" },
            { "timezone.excity.America/Indiana/Knox", "Knox" },
            { "timezone.excity.America/Indiana/Vevay", "Vevay" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia dal Sid" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo" },
            { "timezone.excity.America/Indiana/Winamac", "Winamac" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushua\u00efa" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell City" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincennes" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan, Argentinia" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg" },
            { "timezone.excity.America/Kentucky/Monticello", "Monticello" },
            { "timezone.excity.America/North_Dakota/Center", "North Dakota (Central)" },
            { "timezone.excity.America/North_Dakota/New_Salem", "North Dakota (New Salem)" },
        };
        return data;
    }
}
