/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ca extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e0rab";
        final String metaValue_hy = "armeni";
        final String metaValue_ae = "av\u00e8stic";
        final String metaValue_ban = "balin\u00e8s";
        final String metaValue_bax = "bamum";
        final String metaValue_bn = "bengal\u00ed";
        final String metaValue_zbl = "s\u00edmbols Bliss";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copte";
        final String metaValue_ka = "georgi\u00e0";
        final String metaValue_got = "g\u00f2tic";
        final String metaValue_el = "grec";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebreu";
        final String metaValue_jv = "javan\u00e8s";
        final String metaValue_ja = "japon\u00e8s";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "core\u00e0";
        final String metaValue_kpe = "kpelle";
        final String metaValue_la = "llat\u00ed";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malai\u00e0lam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birm\u00e0";
        final String metaValue_nqo = "n\u2019Ko";
        final String metaValue_sat = "santali";
        final String metaValue_or = "oriya";
        final String metaValue_osa = "osage";
        final String metaValue_pal = "pahlavi";
        final String metaValue_phn = "fenici";
        final String metaValue_si = "singal\u00e8s";
        final String metaValue_syr = "sir\u00edac";
        final String metaValue_ta = "t\u00e0mil";
        final String metaValue_te = "telugu";
        final String metaValue_bo = "tibet\u00e0";
        final String metaValue_uga = "ugar\u00edtic";
        final String metaValue_vai = "vai";
        final String metaValue_peo = "persa antic";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "M\u00f3n" },
            { "002", "\u00c0frica" },
            { "003", "Am\u00e8rica del Nord" },
            { "005", "Am\u00e8rica del Sud" },
            { "009", "Oceania" },
            { "011", "\u00c0frica occidental" },
            { "013", "Am\u00e8rica Central" },
            { "014", "\u00c0frica oriental" },
            { "015", "\u00c0frica septentrional" },
            { "017", "\u00c0frica central" },
            { "018", "\u00c0frica meridional" },
            { "019", "Am\u00e8rica" },
            { "021", "Am\u00e8rica septentrional" },
            { "029", "Carib" },
            { "030", "\u00c0sia oriental" },
            { "034", "\u00c0sia meridional" },
            { "035", "\u00c0sia sud-oriental" },
            { "039", "Europa meridional" },
            { "053", "Austral\u00e0sia" },
            { "054", "Melan\u00e8sia" },
            { "057", "Regi\u00f3 de la Micron\u00e8sia" },
            { "061", "Polin\u00e8sia" },
            { "142", "\u00c0sia" },
            { "143", "\u00c0sia central" },
            { "145", "\u00c0sia occidental" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "155", "Europa occidental" },
            { "202", "\u00c0frica subsahariana" },
            { "419", "Am\u00e8rica Llatina" },
            { "AC", "Illa de l\u2019Ascensi\u00f3" },
            { "AD", "Andorra" },
            { "AE", "Emirats \u00c0rabs Units" },
            { "AF", "Afganistan" },
            { "AG", "Antigua i Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Alb\u00e0nia" },
            { "AM", "Arm\u00e8nia" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e0rtida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "\u00c0ustria" },
            { "AU", "Austr\u00e0lia" },
            { "AW", "Aruba" },
            { "AX", "Illes \u00c5land" },
            { "AZ", "Azerbaidjan" },
            { "BA", "B\u00f2snia i Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "B\u00e8lgica" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulg\u00e0ria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermudes" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Carib Neerland\u00e8s" },
            { "BR", "Brasil" },
            { "BS", "Bahames" },
            { "BT", "Bhutan" },
            { "BV", "Illa Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belar\u00fas" },
            { "BZ", "Belize" },
            { "CA", "Canad\u00e0" },
            { "CC", "Illes Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Rep\u00fablica Centreafricana" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Su\u00efssa" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Illes Cook" },
            { "CL", "Xile" },
            { "CM", "Camerun" },
            { "CN", "Xina" },
            { "CO", "Col\u00f2mbia" },
            { "CP", "Illa Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cap Verd" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Illa Christmas" },
            { "CY", "Xipre" },
            { "CZ", "Tx\u00e8quia" },
            { "DE", "Alemanya" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "DZ", "Alg\u00e8ria" },
            { "EA", "Ceuta i Melilla" },
            { "EC", "Equador" },
            { "EE", "Est\u00f2nia" },
            { "EG", "Egipte" },
            { "EH", "S\u00e0hara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "Espanya" },
            { "ET", "Eti\u00f2pia" },
            { "EU", "Uni\u00f3 Europea" },
            { "EZ", "zona euro" },
            { "FI", "Finl\u00e0ndia" },
            { "FJ", "Fiji" },
            { "FK", "Illes Malvines" },
            { "FM", "Micron\u00e8sia" },
            { "FO", "Illes F\u00e8roe" },
            { "FR", "Fran\u00e7a" },
            { "GA", "Gabon" },
            { "GB", "Regne Unit" },
            { "GD", "Grenada" },
            { "GE", "Ge\u00f2rgia" },
            { "GF", "Guaiana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenl\u00e0ndia" },
            { "GM", "G\u00e0mbia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Equatorial" },
            { "GR", "Gr\u00e8cia" },
            { "GS", "Illes Ge\u00f2rgia del Sud i Sandwich del Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong (RAE Xina)" },
            { "HM", "Illes Heard i McDonald" },
            { "HN", "Hondures" },
            { "HR", "Cro\u00e0cia" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hongria" },
            { "IC", "Illes Can\u00e0ries" },
            { "ID", "Indon\u00e8sia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Illa de Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Territori Brit\u00e0nic de l\u2019Oce\u00e0 \u00cdndic" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Isl\u00e0ndia" },
            { "IT", "It\u00e0lia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jord\u00e0nia" },
            { "JP", "Jap\u00f3" },
            { "KE", "Kenya" },
            { "KG", "Kirguizstan" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "KN", "Saint Kitts i Nevis" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "KW", "Kuwait" },
            { "KY", "Illes Caiman" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "L\u00edban" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Lib\u00e8ria" },
            { "LS", "Lesotho" },
            { "LT", "Litu\u00e0nia" },
            { "LU", "Luxemburg" },
            { "LV", "Let\u00f2nia" },
            { "LY", "L\u00edbia" },
            { "MA", "Marroc" },
            { "MC", "M\u00f2naco" },
            { "MD", "Mold\u00e0via" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Illes Marshall" },
            { "MK", "Maced\u00f2nia del Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birm\u00e0nia)" },
            { "MN", "Mong\u00f2lia" },
            { "MO", "Macau (RAE Xina)" },
            { "MP", "Illes Marianes del Nord" },
            { "MQ", "Martinica" },
            { "MR", "Maurit\u00e0nia" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maurici" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "M\u00e8xic" },
            { "MY", "Mal\u00e0isia" },
            { "MZ", "Mo\u00e7ambic" },
            { "NA", "Nam\u00edbia" },
            { "NC", "Nova Caled\u00f2nia" },
            { "NE", "N\u00edger" },
            { "NF", "Norfolk" },
            { "NG", "Nig\u00e8ria" },
            { "NI", "Nicaragua" },
            { "NL", "Pa\u00efsos Baixos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zelanda" },
            { "OM", "Oman" },
            { "PA", "Panam\u00e0" },
            { "PE", "Per\u00fa" },
            { "PF", "Polin\u00e8sia Francesa" },
            { "PG", "Papua Nova Guinea" },
            { "PH", "Filipines" },
            { "PK", "Pakistan" },
            { "PL", "Pol\u00f2nia" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Illes Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territoris palestins" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Qatar" },
            { "QO", "Territoris allunyats d\u2019Oceania" },
            { "RE", "Illa de la Reuni\u00f3" },
            { "RO", "Romania" },
            { "RS", "S\u00e8rbia" },
            { "RU", "R\u00fassia" },
            { "RW", "Ruanda" },
            { "SA", "Ar\u00e0bia Saud\u00ed" },
            { "SB", "Illes Salom\u00f3" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Su\u00e8cia" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "SI", "Eslov\u00e8nia" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "SK", "Eslov\u00e0quia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e0lia" },
            { "SR", "Surinam" },
            { "SS", "Sudan del Sud" },
            { "ST", "S\u00e3o Tom\u00e9 i Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00edria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Illes Turks i Caicos" },
            { "TD", "Txad" },
            { "TF", "Territoris Australs Francesos" },
            { "TG", "Togo" },
            { "TH", "Tail\u00e0ndia" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tun\u00edsia" },
            { "TO", "Tonga" },
            { "TR", "Turquia" },
            { "TT", "Trinitat i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanz\u00e0nia" },
            { "UA", "Ucra\u00efna" },
            { "UG", "Uganda" },
            { "UM", "Illes Perif\u00e8riques Menors dels EUA" },
            { "UN", "Nacions Unides" },
            { "US", "Estats Units" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "VA", "Ciutat del Vatic\u00e0" },
            { "VC", "Saint Vincent i les Grenadines" },
            { "VE", "Vene\u00e7uela" },
            { "VG", "Illes Verges brit\u00e0niques" },
            { "VI", "Illes Verges nord-americanes" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudoaccents" },
            { "XB", "pseudobidi" },
            { "XK", "Kosovo" },
            { "YE", "Iemen" },
            { "YT", "Mayotte" },
            { "ZA", "Rep\u00fablica de Sud-\u00e0frica" },
            { "ZM", "Z\u00e0mbia" },
            { "ZW", "Zimb\u00e0bue" },
            { "ZZ", "regi\u00f3 desconeguda" },
            { "aa", "\u00e0far" },
            { "ab", "abkhaz" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "\u00e0kan" },
            { "am", "amh\u00e0ric" },
            { "an", "aragon\u00e8s" },
            { "ar", metaValue_ar },
            { "as", "assam\u00e8s" },
            { "av", "\u00e0var" },
            { "ay", "aimara" },
            { "az", "azerbaidjan\u00e8s" },
            { "ba", "baixkir" },
            { "be", "belar\u00fas" },
            { "bg", "b\u00falgar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bret\u00f3" },
            { "bs", "bosni\u00e0" },
            { "ca", "catal\u00e0" },
            { "ce", "txetx\u00e8" },
            { "ch", "chamorro" },
            { "co", "cors" },
            { "cr", "cree" },
            { "cs", "txec" },
            { "cu", "eslau eclesi\u00e0stic" },
            { "cv", "txuvaix" },
            { "cy", "gal\u00b7l\u00e8s" },
            { "da", "dan\u00e8s" },
            { "de", "alemany" },
            { "dv", "divehi" },
            { "dz", "dzongka" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "angl\u00e8s" },
            { "eo", "esperanto" },
            { "es", "espanyol" },
            { "et", "estoni\u00e0" },
            { "eu", "basc" },
            { "fa", "persa" },
            { "ff", "ful" },
            { "fi", "fin\u00e8s" },
            { "fj", "fiji\u00e0" },
            { "fo", "fero\u00e8s" },
            { "fr", "franc\u00e8s" },
            { "fy", "fris\u00f3 occidental" },
            { "ga", "irland\u00e8s" },
            { "gd", "ga\u00e8lic escoc\u00e8s" },
            { "gl", "gallec" },
            { "gn", "guaran\u00ed" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "haussa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croat" },
            { "ht", "crioll d\u2019Hait\u00ed" },
            { "hu", "hongar\u00e8s" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesi" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi sichuan" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "island\u00e8s" },
            { "it", "itali\u00e0" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuiu" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenland\u00e8s" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "caixmiri" },
            { "ku", "kurd" },
            { "kv", "komi" },
            { "kw", "c\u00f2rnic" },
            { "ky", "kirgu\u00eds" },
            { "la", metaValue_la },
            { "lb", "luxemburgu\u00e8s" },
            { "lg", "ganda" },
            { "li", "limburgu\u00e8s" },
            { "ln", "lingala" },
            { "lo", "laosi\u00e0" },
            { "lt", "litu\u00e0" },
            { "lu", "luba katanga" },
            { "lv", "let\u00f3" },
            { "mg", "malgaix" },
            { "mh", "marshall\u00e8s" },
            { "mi", "maori" },
            { "mk", "macedoni" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malai" },
            { "mt", "malt\u00e8s" },
            { "my", metaValue_my },
            { "na", "nauru\u00e0" },
            { "nb", "noruec bokm\u00e5l" },
            { "nd", "ndebele septentrional" },
            { "ne", "nepal\u00e8s" },
            { "ng", "ndonga" },
            { "nl", "neerland\u00e8s" },
            { "nn", "noruec nynorsk" },
            { "no", "noruec" },
            { "nr", "ndebele meridional" },
            { "nv", "navaho" },
            { "ny", "nyanja" },
            { "oc", "occit\u00e0" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osseta" },
            { "pa", "panjabi" },
            { "pi", "pali" },
            { "pl", "polon\u00e8s" },
            { "ps", "paixtu" },
            { "pt", "portugu\u00e8s" },
            { "qu", "qu\u00edtxua" },
            { "rm", "retorom\u00e0nic" },
            { "rn", "rundi" },
            { "ro", "roman\u00e8s" },
            { "ru", "rus" },
            { "rw", "ruand\u00e8s" },
            { "sa", "s\u00e0nscrit" },
            { "sc", "sard" },
            { "sd", "sindi" },
            { "se", "sami septentrional" },
            { "sg", "sango" },
            { "sh", "serbocroat" },
            { "si", metaValue_si },
            { "sk", "eslovac" },
            { "sl", "eslov\u00e8" },
            { "sm", "samo\u00e0" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "alban\u00e8s" },
            { "sr", "serbi" },
            { "ss", "swazi" },
            { "st", "sotho meridional" },
            { "su", "sondan\u00e8s" },
            { "sv", "suec" },
            { "sw", "suahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjik" },
            { "th", "tai" },
            { "ti", "tigrinya" },
            { "tk", "turcman" },
            { "tl", "tagal" },
            { "tn", "setswana" },
            { "to", "tongal\u00e8s" },
            { "tr", "turc" },
            { "ts", "tsonga" },
            { "tt", "t\u00e0tar" },
            { "tw", "twi" },
            { "ty", "tahiti\u00e0" },
            { "ug", "uigur" },
            { "uk", "ucra\u00efn\u00e8s" },
            { "ur", "urd\u00fa" },
            { "uz", "uzbek" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volap\u00fck" },
            { "wa", "val\u00f3" },
            { "wo", "w\u00f2lof" },
            { "xh", "xosa" },
            { "yi", "\u00eddix" },
            { "yo", "ioruba" },
            { "za", "zhuang" },
            { "zh", "xin\u00e8s" },
            { "zu", "zulu" },
            { "ace", "atjeh" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adigu\u00e9" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "accadi" },
            { "akz", "alabama" },
            { "ale", "aleuta" },
            { "aln", "alban\u00e8s geg" },
            { "alt", "altaic meridional" },
            { "ang", "angl\u00e8s antic" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "arameu" },
            { "arn", "mapudungu" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "ars", "\u00e0rab najdi" },
            { "arw", "arauac" },
            { "arz", "\u00e0rab egipci" },
            { "asa", "pare" },
            { "ase", "llengua de signes americana" },
            { "ast", "asturi\u00e0" },
            { "atj", "atacama" },
            { "awa", "awadhi" },
            { "bal", "balutxi" },
            { "ban", metaValue_ban },
            { "bar", "bavar\u00e8s" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgc", "haryanvi" },
            { "bgn", "balutxi occidental" },
            { "bho", "bhojpuri" },
            { "bik", "bicol" },
            { "bin", "edo" },
            { "bkm", "kom" },
            { "bla", "blackfoot" },
            { "bra", "braj" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriat" },
            { "bug", "bugui" },
            { "bum", "bulu" },
            { "byn", "bilin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "carib" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebu\u00e0" },
            { "cgg", "chiga" },
            { "chb", "txibtxa" },
            { "chg", "txagatai" },
            { "chk", "chuuk" },
            { "chm", "mari" },
            { "chn", "pidgin chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "xeiene" },
            { "ckb", "kurd central" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "t\u00e0tar de Crimea" },
            { "crj", "cree sud-oriental" },
            { "crk", "cree de la plana" },
            { "crl", "cree nord-oriental" },
            { "crm", "moose cree" },
            { "crr", "algonqu\u00ed de Carolina" },
            { "crs", "franc\u00e8s crioll de les Seychelles" },
            { "csb", "caixubi" },
            { "csw", "swampy cree" },
            { "dak", "dakota" },
            { "dar", "dargu\u00e0" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slavi" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "baix s\u00f2rab" },
            { "dua", "douala" },
            { "dum", "neerland\u00e8s mitj\u00e0" },
            { "dyo", "diola" },
            { "dyu", "jula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emili\u00e0" },
            { "egy", "egipci antic" },
            { "eka", "ekajuk" },
            { "elx", "elamita" },
            { "enm", "angl\u00e8s mitj\u00e0" },
            { "ewo", "ewondo" },
            { "ext", "extremeny" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filip\u00ed" },
            { "fon", "fon" },
            { "frc", "franc\u00e8s cajun" },
            { "frm", "franc\u00e8s mitj\u00e0" },
            { "fro", "franc\u00e8s antic" },
            { "frr", "fris\u00f3 septentrional" },
            { "frs", "fris\u00f3 oriental" },
            { "fur", "fri\u00fcl\u00e0" },
            { "gaa", "ga" },
            { "gag", "gaga\u00fas" },
            { "gan", "xin\u00e8s gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "gueez" },
            { "gil", "gilbert\u00e8s" },
            { "glk", "gilaki" },
            { "gmh", "alt alemany mitj\u00e0" },
            { "goh", "alt alemany antic" },
            { "gom", "concani de Goa" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "grec antic" },
            { "gsw", "alemany su\u00eds" },
            { "guc", "way\u00fa" },
            { "guz", "gus\u00ed" },
            { "gwi", "gwich\u2019in" },
            { "hai", "haida" },
            { "hak", "xin\u00e8s hakka" },
            { "haw", "hawai\u00e0" },
            { "hax", "haida meridional" },
            { "hif", "hindi de Fiji" },
            { "hil", "h\u00edligaynon" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "alt s\u00f2rab" },
            { "hsn", "xin\u00e8s xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut occidental canadenc" },
            { "ilo", "ilocano" },
            { "inh", "ing\u00faix" },
            { "jam", "crioll angl\u00e8s de Jamaica" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "judeopersa" },
            { "jrb", "judeo\u00e0rab" },
            { "kaa", "karakalpak" },
            { "kab", "cabilenc" },
            { "kac", "katxin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabard\u00ed" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "crioll capverdi\u00e0" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaing\u00e0" },
            { "kha", "khasi" },
            { "kho", "khotan\u00e8s" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permiac" },
            { "kok", "concani" },
            { "kos", "kosrae\u00e0" },
            { "kpe", metaValue_kpe },
            { "krc", "karatxai-balkar" },
            { "kri", "krio" },
            { "krl", "careli\u00e0" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lsch" },
            { "kum", "k\u00famik" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u2019wala" },
            { "lad", "judeocastell\u00e0" },
            { "lag", "langi" },
            { "lah", "panjabi occidental" },
            { "lam", "lamba" },
            { "lez", "lesgui\u00e0" },
            { "lij", "l\u00edgur" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "llombard" },
            { "lol", "mongo" },
            { "lou", "crioll franc\u00e8s de Louisiana" },
            { "loz", "lozi" },
            { "lrc", "luri septentrional" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luisenyo" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "lzh", "xin\u00e8s cl\u00e0ssic" },
            { "lzz", "laz" },
            { "mad", "madur\u00e8s" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makassar" },
            { "man", "mandinga" },
            { "mas", "massai" },
            { "mde", "maba" },
            { "mdf", "mordovi\u00e0 moksa" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "maurici\u00e0" },
            { "mga", "ga\u00e8lic irland\u00e8s mitj\u00e0" },
            { "mgh", "makhuwa-metto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manx\u00fa" },
            { "mni", "manipur\u00ed" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "moore" },
            { "mrj", "mari occidental" },
            { "mua", "mundang" },
            { "mul", "lleng\u00fces v\u00e0ries" },
            { "mus", "creek" },
            { "mwl", "mirand\u00e8s" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "mordovi\u00e0 erza" },
            { "mzn", "mazanderani" },
            { "nan", "xin\u00e8s min del sud" },
            { "nap", "napolit\u00e0" },
            { "naq", "nama" },
            { "nds", "baix alemany" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niue\u00e0" },
            { "nmg", "bissio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "n\u00f2rdic antic" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho septentrional" },
            { "nus", "nuer" },
            { "nwc", "newari cl\u00e0ssic" },
            { "nym", "nyamwesi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzema" },
            { "ojb", "ojibwa septentrional" },
            { "ojc", "ojibwa central" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa occidental" },
            { "oka", "okanag\u00e0" },
            { "osa", metaValue_osa },
            { "ota", "turc otom\u00e0" },
            { "pag", "pangasinan" },
            { "pal", metaValue_pal },
            { "pam", "pampanga" },
            { "pap", "papiament" },
            { "pau", "palau\u00e0" },
            { "pcd", "picard" },
            { "pcm", "pidgin de Nig\u00e8ria" },
            { "pdc", "alemany pennsilvani\u00e0" },
            { "peo", metaValue_peo },
            { "pfl", "alemany palat\u00ed" },
            { "phn", metaValue_phn },
            { "pis", "pidgin" },
            { "pms", "piemont\u00e8s" },
            { "pnt", "p\u00f2ntic" },
            { "pon", "ponape\u00e0" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "prussi\u00e0" },
            { "pro", "proven\u00e7al antic" },
            { "quc", "k\u2019iche\u2019" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotong\u00e0" },
            { "rgn", "romany\u00e8s" },
            { "rhg", "rohingya" },
            { "rof", "rombo" },
            { "rom", "roman\u00ed" },
            { "rup", "aroman\u00e8s" },
            { "rwk", "rwo" },
            { "sad", "sandawe" },
            { "sah", "iacut" },
            { "sam", "arameu samarit\u00e0" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", metaValue_sat },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicili\u00e0" },
            { "sco", "escoc\u00e8s" },
            { "sdc", "sasser\u00e8s" },
            { "sdh", "kurd meridional" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "songhai oriental" },
            { "sga", "irland\u00e8s antic" },
            { "shi", "taixelhit" },
            { "shn", "xan" },
            { "shu", "\u00e0rab txadi\u00e0" },
            { "sid", "sidamo" },
            { "slh", "lushootseed meridional" },
            { "sma", "sami meridional" },
            { "smj", "sami lule" },
            { "smn", "sami d\u2019Inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "sog", "sogdi\u00e0" },
            { "srn", "sranan" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "str", "straits salish" },
            { "suk", "sukuma" },
            { "sus", "sus\u00fa" },
            { "sux", "sumeri" },
            { "swb", "comori\u00e0" },
            { "syc", "sir\u00edac cl\u00e0ssic" },
            { "syr", metaValue_syr },
            { "szl", "silesi\u00e0" },
            { "tce", "tutxone meridional" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "terena" },
            { "tet", "t\u00e8tum" },
            { "tgx", "tagish" },
            { "tht", "tahlt\u00e0" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau\u00e8s" },
            { "tkr", "tsakhur" },
            { "tlh", "klingoni\u00e0" },
            { "tli", "tlingit" },
            { "tly", "talix" },
            { "tmh", "amazic" },
            { "tog", "tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshi\u00e0" },
            { "ttm", "tutxone septentrional" },
            { "ttt", "tat meridional" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu\u00e0" },
            { "twq", "tasawaq" },
            { "tyv", "tuvini\u00e0" },
            { "tzm", "amazic del Marroc central" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "idioma desconegut" },
            { "vai", metaValue_vai },
            { "vec", "v\u00e8net" },
            { "vep", "vepse" },
            { "vls", "flamenc occidental" },
            { "vot", "v\u00f2tic" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaita" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "xin\u00e8s wu" },
            { "xal", "calmuc" },
            { "xmf", "mingreli\u00e0" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yape\u00e0" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengat\u00fa" },
            { "yue", "canton\u00e8s" },
            { "zap", "zapoteca" },
            { "zbl", metaValue_zbl },
            { "zea", "zeland\u00e8s" },
            { "zen", "zenaga" },
            { "zgh", "amazic est\u00e0ndard marroqu\u00ed" },
            { "zun", "zuni" },
            { "zxx", "sense contingut ling\u00fc\u00edstic" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Afak", "afaka" },
            { "Aghb", "alban\u00e8s cauc\u00e0sic" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "nasta\u2019liq" },
            { "Armi", "arameu imperial" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhaiksuki" },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", "bugin\u00e8s" },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "sil\u00b7labari aborigen canadenc unificat" },
            { "Cari", "cari\u00e0" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "xipriota" },
            { "Cyrl", "cir\u00edl\u00b7lic" },
            { "Cyrs", "cir\u00edl\u00b7lic de l\u2019antic eslau eclesi\u00e0stic" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Dupl", "taquigrafia Duploy\u00e9" },
            { "Egyd", "dem\u00f2tic egipci" },
            { "Egyh", "hier\u00e0tic egipci" },
            { "Egyp", "jerogl\u00edfic egipci" },
            { "Elba", "elbasan" },
            { "Ethi", "eti\u00f2pic" },
            { "Geok", "georgi\u00e0 hucuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagol\u00edtic" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han amb bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplificat" },
            { "Hant", "tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "jerogl\u00edfic anatoli" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "sil\u00b7labaris japonesos" },
            { "Hung", "hongar\u00e8s antic" },
            { "Inds", "escriptura de la vall de l\u2019Indus" },
            { "Ital", "cursiva antiga" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "j\u00fcrchen" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharosthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khoja" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "llat\u00ed fraktur" },
            { "Latg", "llat\u00ed ga\u00e8lic" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineal A" },
            { "Linb", "lineal B" },
            { "Lisu", "lisu" },
            { "Loma", "loma" },
            { "Lyci", "lici" },
            { "Lydi", "lidi" },
            { "Mahj", "mahajani" },
            { "Mand", "mandaic" },
            { "Mani", "maniqueu" },
            { "Maya", "jerogl\u00edfics maies" },
            { "Mend", metaValue_men },
            { "Merc", "cursiva mero\u00edtica" },
            { "Mero", "mero\u00edtic" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mroo", "mro" },
            { "Mtei", "manipuri" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Narb", "antic nord-ar\u00e0bic" },
            { "Nbat", "nabateu" },
            { "Newa", "newar" },
            { "Nkgb", "geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "n\u00fc shu" },
            { "Ogam", "ogham" },
            { "Olck", metaValue_sat },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "osmanya" },
            { "Palm", "palmir\u00e8" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "antic p\u00e8rmic" },
            { "Phag", "phagspa" },
            { "Phli", "pahlavi inscripcional" },
            { "Phlp", "psalter pahlavi" },
            { "Phlv", metaValue_pal },
            { "Phnx", metaValue_phn },
            { "Plrd", "pollard miao" },
            { "Prti", "parthi\u00e0 inscripcional" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongo-rongo" },
            { "Runr", "r\u00fanic" },
            { "Samr", "samarit\u00e0" },
            { "Sara", "sarati" },
            { "Sarb", "sud-ar\u00e0bic antic" },
            { "Saur", "saurashtra" },
            { "Sgnw", "escriptura de signes" },
            { "Shaw", "shavi\u00e0" },
            { "Shrd", "shrada" },
            { "Sidd", "siddham" },
            { "Sind", "devangari" },
            { "Sinh", metaValue_si },
            { "Sora", "sora sompeng" },
            { "Sund", "sundan\u00e8s" },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "sir\u00edac estrangelo" },
            { "Syrj", "sir\u00edac occidental" },
            { "Syrn", "sir\u00edac oriental" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "nou tai lue" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinag" },
            { "Tglg", "tag\u00e0log" },
            { "Thaa", "thaana" },
            { "Thai", "tailand\u00e8s" },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhut" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "llenguatge visible" },
            { "Wara", "varang kshiti" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cune\u00efforme sumeri-accadi" },
            { "Yiii", "yi" },
            { "Zinh", "heretat" },
            { "Zmth", "notaci\u00f3 matem\u00e0tica" },
            { "Zsye", "emoji" },
            { "Zsym", "s\u00edmbols" },
            { "Zxxx", "sense escriptura" },
            { "Zyyy", "com\u00fa" },
            { "Zzzz", "escriptura desconeguda" },
            { "de_AT", "alemany austr\u00edac" },
            { "de_CH", "alemany est\u00e0ndard su\u00eds" },
            { "en_AU", "angl\u00e8s australi\u00e0" },
            { "en_CA", "angl\u00e8s canadenc" },
            { "en_GB", "angl\u00e8s brit\u00e0nic" },
            { "en_US", "angl\u00e8s americ\u00e0" },
            { "es_ES", "espanyol europeu" },
            { "es_MX", "espanyol de M\u00e8xic" },
            { "fa_AF", "dari" },
            { "fr_CA", "franc\u00e8s canadenc" },
            { "fr_CH", "franc\u00e8s su\u00eds" },
            { "nl_BE", "flamenc" },
            { "pt_BR", "portugu\u00e8s del Brasil" },
            { "pt_PT", "portugu\u00e8s de Portugal" },
            { "ro_MD", "moldau" },
            { "sw_CD", "suahili del Congo" },
            { "%%1901", "ortografia alemanya tradicional" },
            { "%%1994", "ortografia resiana estandarditzada" },
            { "%%1996", "ortografia alemanya de 1996" },
            { "ar_001", "\u00e0rab est\u00e0ndard modern" },
            { "es_419", "espanyol llatinoameric\u00e0" },
            { "key.ca", "calendari" },
            { "key.cf", "format de moneda" },
            { "key.co", "ordre" },
            { "key.cu", "moneda" },
            { "key.hc", "sistema horari (12 h o 24 h)" },
            { "key.lb", "estil de salt de l\u00ednia" },
            { "key.ms", "sistema de mesures" },
            { "key.nu", "xifres" },
            { "key.tz", "zona hor\u00e0ria" },
            { "key.va", "variant local" },
            { "nds_NL", "baix sax\u00f3" },
            { "%%ALUKU", "dialecte aluku" },
            { "%%BISKE", "dialecte de San Giorgio/Bila" },
            { "%%BOONT", "Boontling" },
            { "%%JAUER", "jauer" },
            { "%%KKCOR", "ortografia comuna" },
            { "%%LIPAW", "dialecte Lipovaz del resi\u00e0" },
            { "%%NEDIS", "dialecte de Natisone" },
            { "%%NJIVA", "dialecte de Gniva/Njiva" },
            { "%%OSOJS", "dialecte d\u2019Oseacco/Osojane" },
            { "%%POSIX", "ordinador" },
            { "%%PUTER", "alt engiadin\u00e8s" },
            { "%%ROZAJ", "resi\u00e0" },
            { "%%RUMGR", "interomanx" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "dialecte de Stolvizza/Solbica" },
            { "%%UCCOR", "ortografia unificada" },
            { "zh_Hans", "xin\u00e8s simplificat" },
            { "zh_Hant", "xin\u00e8s tradicional" },
            { "%%FONIPA", "alfabet fon\u00e8tic internacional" },
            { "%%FONUPA", "sistema fon\u00e8tic UPA" },
            { "%%NDYUKA", "dialecte ndyuka" },
            { "%%PAMAKA", "dialecte pamaka" },
            { "%%PINYIN", "romanitzaci\u00f3 Pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "ortografia taraskievica" },
            { "%%UCRCOR", "ortografia revisada unificada" },
            { "%%ULSTER", "ulster" },
            { "%%ALALC97", "romanitzaci\u00f3 ALA/LC, edici\u00f3 de 1997" },
            { "%%AREVELA", "armeni oriental" },
            { "%%AREVMDA", "armeni occidental" },
            { "%%BAUDDHA", "bauddha" },
            { "%%HEPBURN", "romanitzaci\u00f3 Hepburn" },
            { "%%ITIHASA", "itihasa" },
            { "%%LAUKIKA", "laukika" },
            { "%%MONOTON", "monot\u00f2nic" },
            { "%%POLYTON", "polit\u00f2nic" },
            { "%%REVISED", "ortografia revisada" },
            { "%%SURSILV", "sobreselv\u00e0" },
            { "%%SUTSILV", "sotaselv\u00e0" },
            { "%%VAIDIKA", "v\u00e8dic" },
            { "%%1606NICT", "franc\u00e8s mitj\u00e0 tard\u00e0 fins el 1606" },
            { "%%1694ACAD", "franc\u00e8s modern primerenc" },
            { "%%1959ACAD", "acad\u00e8mica" },
            { "%%BAKU1926", "alfabet llat\u00ed turc unificat" },
            { "%%BISCAYAN", "basc bisca\u00ed" },
            { "%%FONXSAMP", "sistema X-SAMPA" },
            { "%%HOGNORSK", "h\u00f8gnorsk" },
            { "%%JYUTPING", "jyupting" },
            { "%%LUNA1918", "luna 1918" },
            { "%%PETR1708", "ortografia russa 1708\u20131917" },
            { "%%SCOTLAND", "angl\u00e8s est\u00e0ndard d\u2019Esc\u00f2cia" },
            { "%%SURMIRAN", "surmiran" },
            { "%%VALENCIA", "valenci\u00e0" },
            { "%%VALLADER", "baix engiadin\u00e8s" },
            { "%%WADEGILE", "romanitzaci\u00f3 Wade-Giles" },
            { "type.ca.roc", "calendari de la Rep\u00fablica de Xina" },
            { "type.co.eor", "normes europees d\u2019ordenaci\u00f3" },
            { "type.hc.h11", "sistema de 12 hores (0\u201311)" },
            { "type.hc.h12", "sistema de 12 hores (1\u201312)" },
            { "type.hc.h23", "sistema de 24 hores (0\u201323)" },
            { "type.hc.h24", "sistema de 24 hores (1\u201324)" },
            { "type.m0.bgn", "sistema de transliteraci\u00f3 BGN" },
            { "type.nu.arab", "xifres indoar\u00e0bigues" },
            { "type.nu.armn", "nombres armenis" },
            { "type.nu.bali", "d\u00edgits balinesos" },
            { "type.nu.beng", "d\u00edgits bengalins" },
            { "type.nu.cakm", "d\u00edgits chakma" },
            { "type.nu.cham", "d\u00edgits txams" },
            { "type.nu.deva", "d\u00edgits devanagaris" },
            { "type.nu.ethi", "nombres eti\u00f2pics" },
            { "type.nu.geor", "nombres georgians" },
            { "type.nu.grek", "nombres grecs" },
            { "type.nu.gujr", "d\u00edgits gujarati" },
            { "type.nu.guru", "d\u00edgits gurmukhi" },
            { "type.nu.hans", "nombres xinesos simplificats" },
            { "type.nu.hant", "nombres xinesos tradicionals" },
            { "type.nu.hebr", "nombres hebreus" },
            { "type.nu.java", "d\u00edgits javanesos" },
            { "type.nu.jpan", "nombres japonesos" },
            { "type.nu.kali", "d\u00edgits kayah" },
            { "type.nu.khmr", "d\u00edgits khmer" },
            { "type.nu.knda", "d\u00edgits kannada" },
            { "type.nu.lana", "d\u00edgits tai tham hora" },
            { "type.nu.laoo", "d\u00edgits lao" },
            { "type.nu.latn", "d\u00edgits ar\u00e0bics" },
            { "type.nu.lepc", "d\u00edgits lepcha" },
            { "type.nu.limb", "d\u00edgits limbu" },
            { "type.nu.mlym", "d\u00edgits malai\u00e0lam" },
            { "type.nu.mong", "d\u00edgits mongols" },
            { "type.nu.mtei", "d\u00edgits meitei mayek" },
            { "type.nu.mymr", "d\u00edgits de Myanmar" },
            { "type.nu.nkoo", "d\u00edgits n\u2019ko" },
            { "type.nu.olck", "d\u00edgits ol chiki" },
            { "type.nu.orya", "d\u00edgits oriya" },
            { "type.nu.saur", "d\u00edgits saurashtra" },
            { "type.nu.sund", "d\u00edgits sudanesos" },
            { "type.nu.talu", "d\u00edgits tai lue nous" },
            { "type.nu.taml", "nombres tamils tradicionals" },
            { "type.nu.telu", "d\u00edgits telugu" },
            { "type.nu.thai", "d\u00edgits tai" },
            { "type.nu.tibt", "d\u00edgits tibetans" },
            { "type.nu.vaii", "d\u00edgits vai" },
            { "type.ca.dangi", "calendari dangi" },
            { "type.co.ducet", "ordre Unicode predeterminat" },
            { "type.lb.loose", "salt de l\u00ednia flexible" },
            { "type.nu.roman", "nombres romans" },
            { "type.ca.coptic", "calendari copte" },
            { "type.ca.hebrew", "calendari hebreu" },
            { "type.ca.indian", "calendari hind\u00fa" },
            { "type.co.compat", "ordre anterior, per a compatibilitat" },
            { "type.co.pinyin", "ordre pinyin" },
            { "type.co.search", "cerca de prop\u00f2sit general" },
            { "type.co.stroke", "ordre dels tra\u00e7os" },
            { "type.co.unihan", "ordre de tra\u00e7os radicals" },
            { "type.co.zhuyin", "ordre zhuyin" },
            { "type.d0.fwidth", "amplada completa" },
            { "type.d0.hwidth", "amplada mitjana" },
            { "type.lb.normal", "salt de l\u00ednia normal" },
            { "type.lb.strict", "salt de l\u00ednia estricte" },
            { "type.m0.ungegn", "sistema de transliteraci\u00f3 UNGEGN" },
            { "type.ms.metric", "sistema m\u00e8tric" },
            { "type.nu.native", "d\u00edgits natius" },
            { "type.ca.chinese", "calendari xin\u00e8s" },
            { "type.ca.islamic", "calendari isl\u00e0mic" },
            { "type.ca.iso8601", "calendari ISO-8601" },
            { "type.ca.persian", "calendari persa" },
            { "type.cf.account", "format de moneda comptable" },
            { "type.co.big5han", "ordre del xin\u00e8s tradicional - Big5" },
            { "type.d0.npinyin", "Num\u00e8ric" },
            { "type.nu.arabext", "xifres indoar\u00e0bigues ampliades" },
            { "type.nu.armnlow", "nombres armenis en min\u00fascula" },
            { "type.nu.finance", "Numerals financers" },
            { "type.nu.greklow", "nombres grecs en min\u00fascula" },
            { "type.nu.hanidec", "nombres decimals xinesos" },
            { "type.nu.hansfin", "nombres financers xinesos simplificats" },
            { "type.nu.hantfin", "nombres financers xinesos tradicionals" },
            { "type.nu.jpanfin", "nombres financers japonesos" },
            { "type.nu.tamldec", "d\u00edgits tamils" },
            { "type.ca.buddhist", "calendari budista" },
            { "type.ca.ethiopic", "calendari et\u00edop" },
            { "type.ca.japanese", "calendari japon\u00e8s" },
            { "type.cf.standard", "format de moneda est\u00e0ndard" },
            { "type.co.phonetic", "ordre fon\u00e8tic" },
            { "type.co.reformed", "ordre reformat" },
            { "type.co.searchjl", "cerca per consonant inicial del hangul" },
            { "type.co.standard", "ordre est\u00e0ndard" },
            { "type.ms.uksystem", "sistema imperial d\u2019unitats" },
            { "type.ms.ussystem", "sistema d\u2019unitats dels EUA" },
            { "type.nu.fullwide", "d\u00edgits d\u2019amplada completa" },
            { "type.nu.lanatham", "d\u00edgits tai tham tham" },
            { "type.nu.mymrshan", "d\u00edgits shan de Myanmar" },
            { "type.nu.romanlow", "nombres romans en min\u00fascula" },
            { "type.ca.gregorian", "calendari gregori\u00e0" },
            { "type.co.gb2312han", "ordre del xin\u00e8s simplificat - GB2312" },
            { "type.co.phonebook", "ordre de la guia telef\u00f2nica" },
            { "type.co.dictionary", "ordre de diccionari" },
            { "type.co.traditional", "ordre tradicional" },
            { "type.nu.traditional", "Numerals tradicionals" },
            { "type.ca.islamic-civil", "calendari civil isl\u00e0mic" },
            { "type.ca.islamic-umalqura", "calendari isl\u00e0mic (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "calendari et\u00edop amete-alem" },
        };
        return data;
    }
}
