/*
 * Decompiled with CFR 0.152.
 */
package com.turnkeyapparel.print.utils;

import com.turnkeyapparel.print.entities.Printer;
import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.UsbConnection;
import com.zebra.sdk.printer.PrinterStatus;
import com.zebra.sdk.printer.ZebraPrinter;
import com.zebra.sdk.printer.ZebraPrinterFactory;
import com.zebra.sdk.printer.ZebraPrinterLanguageUnknownException;
import com.zebra.sdk.printer.discovery.DiscoveredPrinterFilter;
import com.zebra.sdk.printer.discovery.DiscoveredUsbPrinter;
import com.zebra.sdk.printer.discovery.UsbDiscoverer;
import com.zebra.sdk.printer.discovery.ZebraPrinterFilter;
import java.util.ArrayList;
import java.util.List;

public class PrinterUtils {
    public static String MODEL = "MODEL";
    public static String ADDRESS = "ADDRESS";
    public static String SERIAL_NUMBER = "SERIAL_NUMBER";

    public static List<Printer> getPrinters() {
        ArrayList<Printer> printers = new ArrayList<Printer>();
        try {
            DiscoveredUsbPrinter[] discoveredUsbPrinterArray = UsbDiscoverer.getZebraUsbPrinters((DiscoveredPrinterFilter)new ZebraPrinterFilter());
            int n = discoveredUsbPrinterArray.length;
            int n2 = 0;
            while (n2 < n) {
                DiscoveredUsbPrinter usbPrinter = discoveredUsbPrinterArray[n2];
                Printer printer = new Printer();
                printer.setAddress(usbPrinter.address);
                printer.setModel((String)usbPrinter.getDiscoveryDataMap().get(MODEL));
                printer.setSerial((String)usbPrinter.getDiscoveryDataMap().get(SERIAL_NUMBER));
                printers.add(printer);
                ++n2;
            }
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        return printers;
    }

    public static List<Printer> getPrintersWithStatus() {
        ArrayList<Printer> printers = new ArrayList<Printer>();
        try {
            DiscoveredUsbPrinter[] discoveredUsbPrinterArray = UsbDiscoverer.getZebraUsbPrinters((DiscoveredPrinterFilter)new ZebraPrinterFilter());
            int n = discoveredUsbPrinterArray.length;
            int n2 = 0;
            while (n2 < n) {
                DiscoveredUsbPrinter usbPrinter = discoveredUsbPrinterArray[n2];
                Printer printer = new Printer();
                printer.setAddress(usbPrinter.address);
                printer.setModel((String)usbPrinter.getDiscoveryDataMap().get(MODEL));
                printer.setSerial((String)usbPrinter.getDiscoveryDataMap().get(SERIAL_NUMBER));
                try {
                    Connection zc = usbPrinter.getConnection();
                    zc.open();
                    ZebraPrinter pt = ZebraPrinterFactory.getInstance((Connection)zc);
                    PrinterStatus printerStatus = pt.getCurrentStatus();
                    if (printerStatus.isReadyToPrint) {
                        printer.setIsReady(Boolean.valueOf(true));
                    } else if (printerStatus.isPaused) {
                        printer.setIsReady(Boolean.valueOf(false));
                        printer.setMessage("Cannot Print because the printer is paused.");
                    } else if (printerStatus.isHeadOpen) {
                        printer.setIsReady(Boolean.valueOf(false));
                        printer.setMessage("Cannot Print because the printer head is open");
                    } else if (printerStatus.isPaperOut) {
                        printer.setIsReady(Boolean.valueOf(false));
                        printer.setMessage("Cannot Print because the paper is out.");
                    } else {
                        printer.setIsReady(Boolean.valueOf(false));
                        printer.setMessage("It was impossible to establish a connection with the printer, please check it.");
                    }
                    zc.close();
                }
                catch (ConnectionException e) {
                    printer.setMessage("It was impossible to establish a connection with the printer, please check it.");
                    printer.setIsReady(Boolean.valueOf(false));
                }
                catch (ZebraPrinterLanguageUnknownException e) {
                    printer.setMessage("It was impossible to establish a connection with the printer, please check it.");
                    printer.setIsReady(Boolean.valueOf(false));
                }
                printers.add(printer);
                ++n2;
            }
        }
        catch (ConnectionException e) {
            e.printStackTrace();
        }
        return printers;
    }

    public static Printer getStatusPrinter(String address) {
        Printer printer = new Printer();
        try {
            printer.setAddress(address);
            UsbConnection con = new UsbConnection(address);
            con.open();
            ZebraPrinter pt = ZebraPrinterFactory.getInstance((Connection)con);
            PrinterStatus printerStatus = pt.getCurrentStatus();
            if (printerStatus.isReadyToPrint) {
                printer.setIsReady(Boolean.valueOf(true));
            } else if (printerStatus.isPaused) {
                printer.setIsReady(Boolean.valueOf(false));
                printer.setMessage("Cannot Print because the printer is paused.\nPlease check it physically.");
            } else if (printerStatus.isHeadOpen) {
                printer.setIsReady(Boolean.valueOf(false));
                printer.setMessage("Cannot Print because the printer head is open.\nPlease check it physically.");
            } else if (printerStatus.isPaperOut) {
                printer.setIsReady(Boolean.valueOf(false));
                printer.setMessage("Cannot Print because the paper is out.\nPlease check it physically.");
            } else {
                printer.setIsReady(Boolean.valueOf(false));
                printer.setMessage("It was impossible to establish a connection with the printer, please check it.\nPlease check it physically.");
            }
            con.close();
        }
        catch (ConnectionException | ZebraPrinterLanguageUnknownException e) {
            printer.setIsReady(Boolean.valueOf(false));
            printer.setMessage("It was impossible to establish a connection with the printer, please check it.");
        }
        return printer;
    }

    public static Printer getStatusPrinter(Connection con, byte[] content) {
        Printer printer = new Printer();
        try {
            con.open();
            ZebraPrinter pt = ZebraPrinterFactory.getInstance((Connection)con);
            PrinterStatus printerStatus = pt.getCurrentStatus();
            if (printerStatus.isReadyToPrint) {
                printer.setIsReady(Boolean.valueOf(true));
                con.write(content);
            } else if (printerStatus.isPaused) {
                printer.setIsReady(Boolean.valueOf(false));
                printer.setMessage("Cannot Print because the printer is paused.\nPlease check it physically.");
            } else if (printerStatus.isHeadOpen) {
                printer.setIsReady(Boolean.valueOf(false));
                printer.setMessage("Cannot Print because the printer head is open.\nPlease check it physically.");
            } else if (printerStatus.isPaperOut) {
                printer.setIsReady(Boolean.valueOf(false));
                printer.setMessage("Cannot Print because the paper is out.\nPlease check it physically.");
            } else {
                printer.setIsReady(Boolean.valueOf(false));
                printer.setMessage("It was impossible to establish a connection with the printer, please check it.");
            }
            con.close();
        }
        catch (ConnectionException | ZebraPrinterLanguageUnknownException e) {
            printer.setIsReady(Boolean.valueOf(false));
            printer.setMessage("It was impossible to establish a connection with the printer, please check it.");
        }
        return printer;
    }

    public static Connection getConnection(Printer pr) {
        try {
            return new UsbConnection(pr.getAddress());
        }
        catch (ConnectionException e) {
            e.printStackTrace();
            return null;
        }
    }
}

