/*
 * Decompiled with CFR 0.152.
 */
package com.turnkeyapparel.print.controllers;

import com.turnkeyapparel.print.entities.Config;
import com.turnkeyapparel.print.entities.Printer;
import com.turnkeyapparel.print.entities.So;
import com.turnkeyapparel.print.repositories.ConfigRepository;
import com.turnkeyapparel.print.repositories.SoRepository;
import com.turnkeyapparel.print.request.PrinterRequest;
import com.turnkeyapparel.print.utils.PrinterUtils;
import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.comm.UsbConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PrintController {
    private final String MESSAGE = "message";
    private final String ERROR = "Error";
    private final String STATUS = "success";
    @Autowired
    SoRepository soRepository;
    @Autowired
    ConfigRepository configRepository;
    List<Printer> printers = null;

    @GetMapping(value={"/ping"})
    public Map<String, String> ckeck() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("Available", "OK");
        return response;
    }

    @PostMapping(value={"/calibrate"})
    public Map<String, String> calibratePinter(@RequestBody PrinterRequest printer) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            UsbConnection con = new UsbConnection(printer.getPrinter());
            if (con != null) {
                con.open();
                con.write("~JC".getBytes());
                con.close();
            }
        }
        catch (Exception e) {
            response.put("message", "It was not possible to establish a connection with the printer.");
        }
        return response;
    }

    @PostMapping(value={"/print"})
    public Map<String, String> print(@RequestBody So so) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            Config config = this.configRepository.findTopByOrderByCreatedAtDesc();
            if (!so.getLabelary().booleanValue()) {
                InputStream png = new URL(so.getPng()).openStream();
                byte[] source = IOUtils.toByteArray((InputStream)png);
                so.setPng(Base64.getEncoder().encodeToString(source));
            } else {
                so.setPdf(this.getFromLabelary(so.getZpl(), "application/pdf"));
                so.setPng(this.getFromLabelary(so.getZpl(), "image/png"));
            }
            this.print(config, so, response);
            this.soRepository.save((Object)so);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.put("message", "Error with label file, please check if it is available. ");
            response.put("success", "false");
        }
        return response;
    }

    void print(Config config, So so, Map<String, String> response) {
        String address = "";
        Printer printer = null;
        try {
            byte[] zpl = IOUtils.EMPTY_BYTE_ARRAY;
            zpl = so.getLabelary() == false ? IOUtils.toByteArray((URL)new URL(so.getZpl())) : so.getZpl().getBytes();
            switch (so.getCarrier()) {
                case "USPS": {
                    if (config.usps.length() <= 5) break;
                    address = config.usps;
                    break;
                }
                case "UPS": {
                    if (config.ups.length() <= 5) break;
                    address = config.ups;
                    break;
                }
                default: {
                    if (config.getDefaultPrint().length() <= 5) break;
                    address = config.ups;
                }
            }
            if (address != null && address.length() > 5) {
                printer = PrinterUtils.getStatusPrinter((Connection)new UsbConnection(address), (byte[])zpl);
            } else if (config.defaultPrint.length() > 5) {
                printer = PrinterUtils.getStatusPrinter((Connection)new UsbConnection(config.defaultPrint), (byte[])zpl);
            }
            if (printer != null) {
                if (printer.getIsReady().booleanValue()) {
                    response.put("success", "true");
                } else {
                    response.put("success", "false");
                    response.put("message", printer.getMessage());
                    so.setStatus("Error");
                }
            } else {
                response.put("success", "false");
                response.put("message", "It was not possible to establish a connection with the printer.");
                so.setStatus("Error");
            }
        }
        catch (ConnectionException | IOException | NullPointerException e) {
            response.put("message", e.getMessage());
            response.put("success", "false");
            so.setStatus("Error");
        }
    }

    String getFromLabelary(String zpl, String type) {
        try {
            String url = "http://api.labelary.com/v1/printers/8dpmm/labels/4x2/0";
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", type).POST(HttpRequest.BodyPublishers.ofString(zpl)).build();
            HttpResponse<byte[]> result = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
            return Base64.getEncoder().encodeToString(result.body());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

