/*
 * Decompiled with CFR 0.152.
 */
package com.turnkeyapparel.print.controllers;

import com.turnkeyapparel.print.entities.Config;
import com.turnkeyapparel.print.entities.Printer;
import com.turnkeyapparel.print.repositories.ConfigRepository;
import com.turnkeyapparel.print.repositories.SoRepository;
import com.turnkeyapparel.print.utils.PrinterUtils;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Limit;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

@Controller
public class AdminController {
    private List<Printer> printers;
    @Autowired
    SoRepository soRepository;
    @Autowired
    ConfigRepository configRepository;

    @GetMapping(value={"/"})
    public String index(Model model) {
        List lastPrintedSos = this.soRepository.findAllByOrderByCreatedAtDesc(Limit.of((int)50));
        model.addAttribute("labels", (Object)lastPrintedSos);
        return "home";
    }

    @GetMapping(value={"/config"})
    public String config(Model model) {
        Config cnf = this.configRepository.findTopByOrderByCreatedAtDesc();
        model.addAttribute("config", (Object)(cnf == null ? new Config() : cnf));
        this.printers = PrinterUtils.getPrinters();
        model.addAttribute("printers", (Object)this.printers);
        return "config";
    }

    @PostMapping(value={"/config"})
    public String save(@ModelAttribute Config config, Model model) {
        config.setCreatedAt(Timestamp.valueOf(LocalDateTime.now()));
        config.setUpdatedAt(config.getCreatedAt());
        this.printers = PrinterUtils.getPrinters();
        Config cnf = this.configRepository.findTopByOrderByCreatedAtDesc();
        if (cnf != null) {
            config.id = cnf.id;
        }
        this.configRepository.save((Object)config);
        model.addAttribute("config", (Object)config);
        model.addAttribute("printers", (Object)this.printers);
        return "config";
    }
}

