/*
 * Decompiled with CFR 0.152.
 */
package com.turnkeyapparel.print;

import com.turnkeyapparel.helper.ShortcutFactory;
import com.turnkeyapparel.print.repositories.SoRepository;
import java.io.FileNotFoundException;
import java.util.Calendar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

@SpringBootApplication
@EnableScheduling
public class LabelApplication {
    @Autowired
    SoRepository soRepository;

    public static void main(String[] args) {
        try {
            ShortcutFactory.createDesktopShortcut((String)"C:/Program Files/Internet Explorer/iexplore.exe www.google.com", (String)"Shortcut.lnk");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        SpringApplication.run(LabelApplication.class, (String[])args);
    }

    @Scheduled(cron="0 0/3 * * * ?")
    @Transactional
    public void scheduleFixedDelayTask() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(3, -1);
        System.out.println("cleanining data :" + calendar.getTime());
        this.soRepository.deleteByDate(calendar.toInstant());
    }
}

